/*****************************************************************************
*  LPC8xx SCT demo program
*
*  Use SCT timer to generate four-channel PWM
*  SCT_IN0 (assigned to P0_6) is used as ABORT input
*****************************************************************************/
#include "LPC8xx.h"

extern   void SCT_Init(void);

volatile uint32_t numPwmCycles;
volatile int      pwmAborted;
volatile int      pwmPhase;

void SCT_IRQHandler(void)
{
  uint32_t status = LPC_SCT->EVFLAG;

    if (status & (1 << 0))                             // event 0 irq?
    {
        ++numPwmCycles;                                // interrupt once per PWM cycle
    }
    if (status & (1 << 5))                             // event 5 irq?
    {
        pwmAborted = 1;                                // Abort interrupt
    }
    LPC_SCT->EVFLAG = status;                          // clear interrupt flag
}

int main (void)
{
  uint32_t lastCycles;

    LPC_SYSCON->SYSAHBCLKCTRL |= (1 << 7)              // enable clock to SWM
                               | (1 << 8);             // enable the SCT clock

    LPC_SWM->PINASSIGN5 = 0x06FFFFFF;                  // SCT_IN0  at P0_6 used as ABORT
    LPC_SWM->PINASSIGN6 = 0x07FFFFFF;                  // SCT_OUT0 at P0_7  = green trace  = PWM1
    LPC_SWM->PINASSIGN7 = 0xFF0A0908;                  // SCT_OUT1 at P0_8  = red trace    = PWM2
                                                       // SCT_OUT2 at P0_9  = yellow trace = PWM3
                                                       // SCT_OUT3 at P0_10 = blue trace   = PWM4

    SCT_Init();                                        // Initialize SCT0

    while (1)                                          // loop forever
    {
       	if (numPwmCycles != lastCycles)
       	{
            lastCycles = numPwmCycles;
   		    if ((lastCycles % 5) == 0)                 // every few PWM cycles change the duty cycles
   		    {
                LPC_SCT->CONFIG |= (1 << 7);           // NORELOAD_L (U)
                if (pwmPhase == 0)
                {
                	LPC_SCT->MATCHREL[1].U = 200000;
                	LPC_SCT->MATCHREL[3].U = 700000;
                }
                else
                {
                	LPC_SCT->MATCHREL[1].U = 950000;
                	LPC_SCT->MATCHREL[3].U = LPC_SCT->MATCHREL[0].U;	// duty cycle 0 (test conflict resolution)
                }
                LPC_SCT->CONFIG &= ~(1 << 7);          // NORELOAD_L (U)

                ++pwmPhase;
                if (pwmPhase > 1)
                {
                    pwmPhase = 0;
                }
            }
        }
        if (pwmAborted)          /* Demo: Poll ABORT input, and restart timer if abort condition has gone. */
        {
            while (!(LPC_SCT->INPUT & (1 << 0))) ;

            LPC_SCT->CTRL_U &= ~(1 << 2);              /* HALT_L (U) */
            pwmAborted = 0;
        }
    }
}
